/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.LiquidRootPaneUI;
import com.birosoft.liquid.LiquidWindowButtonUI;
import com.birosoft.liquid.SpecialUIButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.UIResource;

class LiquidTitlePane
extends JComponent {
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private static LiquidWindowButtonUI iconButtonUI;
    private static LiquidWindowButtonUI maxButtonUI;
    private static LiquidWindowButtonUI closeButtonUI;
    private static LiquidWindowButtonUI menuButtonUI;
    private boolean prevState = false;
    private boolean isMenuShowed = false;
    Color normalTitleColor = Color.white;
    Color shadowColor = new Color(10, 24, 131);
    Color disabledTitleColor = new Color(216, 228, 244);
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private Action menuAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private JButton menuButton;
    private WindowListener windowListener;
    private ComponentListener windowMoveListener;
    private Window window;
    private JRootPane rootPane;
    private int buttonsWidth;
    private int state;
    private LiquidRootPaneUI rootPaneUI;

    public LiquidTitlePane(JRootPane root, LiquidRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
            this.windowMoveListener = new WindowMoveListener();
            this.window.addComponentListener(this.windowMoveListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
            this.window.removeComponentListener(this.windowMoveListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        if (this.getWindowDecorationStyle() == 1) {
            this.createActions();
            if (!LiquidLookAndFeel.winDecoPanther) {
                this.menuBar = this.createMenuBar();
                this.add(this.menuBar);
            }
            this.createButtons();
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
            if (LiquidLookAndFeel.winDecoPanther) {
                this.add(this.menuButton);
                this.menuButton.putClientProperty("externalFrameButton", Boolean.TRUE);
            }
            this.iconifyButton.putClientProperty("externalFrameButton", Boolean.TRUE);
            this.toggleButton.putClientProperty("externalFrameButton", Boolean.TRUE);
            this.closeButton.putClientProperty("externalFrameButton", Boolean.TRUE);
        } else if (this.getWindowDecorationStyle() != 0) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
            this.closeButton.putClientProperty("externalFrameButton", Boolean.FALSE);
            if (LiquidLookAndFeel.winDecoPanther) {
                this.add(this.menuButton);
                this.menuButton.putClientProperty("externalFrameButton", Boolean.FALSE);
            }
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    private void uninstallDefaults() {
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar(this.createMenu());
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        return this.menuBar;
    }

    private void close() {
        this.isMenuShowed = false;
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        this.isMenuShowed = false;
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(frame.getExtendedState() | 1);
        }
    }

    private void maximize() {
        this.isMenuShowed = false;
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(frame.getExtendedState() | 6);
        }
    }

    private void setMaximizeBounds(Frame frame) {
        if (frame.getMaximizedBounds() != null) {
            return;
        }
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(frame.getGraphicsConfiguration());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screenInsets.top;
        int y = screenInsets.left;
        int w = screenSize.width - x - screenInsets.right;
        int h = screenSize.height - y - screenInsets.bottom;
        Rectangle maxBounds = new Rectangle(x, y, w, h);
        frame.setMaximizedBounds(maxBounds);
    }

    private void restore() {
        this.isMenuShowed = false;
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((frame.getExtendedState() & 1) == 1) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void showMenu(JPopupMenu systemMenu) {
        if (!this.isMenuShowed) {
            systemMenu.show(this, 0, 21);
            this.isMenuShowed = true;
        } else {
            this.isMenuShowed = false;
            systemMenu.setVisible(this.isMenuShowed);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        this.iconifyAction = new IconifyAction();
        this.restoreAction = new RestoreAction();
        this.maximizeAction = new MaximizeAction();
        this.menuAction = new MenuAction();
    }

    private JPopupMenu createMenu() {
        JPopupMenu menu = new JPopupMenu();
        if (this.getWindowDecorationStyle() == 1 || this.getWindowDecorationStyle() == 2) {
            this.addMenuItems(menu);
            menu.putClientProperty("isSystemMenu", Boolean.TRUE);
        }
        return menu;
    }

    private void addMenuItems(JPopupMenu menu) {
        Locale locale = this.getRootPane().getLocale();
        JMenuItem mi = menu.add(this.restoreAction);
        mi.setMnemonic('r');
        mi = menu.add(this.iconifyAction);
        mi.setMnemonic('e');
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            mi = menu.add(this.maximizeAction);
            mi.setMnemonic('x');
        }
        menu.addSeparator();
        mi = menu.add(this.closeAction);
        mi.setMnemonic('c');
    }

    protected void createButtons() {
        if (iconButtonUI == null) {
            iconButtonUI = LiquidWindowButtonUI.createButtonUIForType(2);
            maxButtonUI = LiquidWindowButtonUI.createButtonUIForType(1);
            closeButtonUI = LiquidWindowButtonUI.createButtonUIForType(0);
            if (LiquidLookAndFeel.winDecoPanther) {
                menuButtonUI = LiquidWindowButtonUI.createButtonUIForType(4);
            }
        }
        this.iconifyButton = new SpecialUIButton((ButtonUI)iconButtonUI, (Window)this.getRootPane().getParent());
        this.iconifyButton.setAction(this.iconifyAction);
        this.iconifyButton.setRolloverEnabled(true);
        this.toggleButton = new SpecialUIButton((ButtonUI)maxButtonUI, (Window)this.getRootPane().getParent());
        this.toggleButton.setAction(this.maximizeAction);
        this.toggleButton.setRolloverEnabled(true);
        this.closeButton = new SpecialUIButton((ButtonUI)closeButtonUI, (Window)this.getRootPane().getParent());
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setRolloverEnabled(true);
        if (LiquidLookAndFeel.winDecoPanther) {
            this.menuButton = new SpecialUIButton((ButtonUI)menuButtonUI, (Window)this.getRootPane().getParent());
            this.menuButton.setAction(this.menuAction);
            this.menuButton.setRolloverEnabled(true);
            this.menuButton.getAccessibleContext().setAccessibleName("Menu");
        }
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
        this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        if (this.getWindowDecorationStyle() == 1) {
            Boolean activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
            this.iconifyButton.putClientProperty("paintActive", activeB);
            this.closeButton.putClientProperty("paintActive", activeB);
            this.toggleButton.putClientProperty("paintActive", activeB);
            this.iconifyButton.setEnabled(isActive);
            this.closeButton.setEnabled(isActive);
            this.toggleButton.setEnabled(isActive);
            if (LiquidLookAndFeel.winDecoPanther) {
                this.menuButton.putClientProperty("paintActive", activeB);
                this.menuButton.setEnabled(isActive);
            }
        }
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (w != null && (this.getWindowDecorationStyle() == 1 || this.getWindowDecorationStyle() == 2)) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) == 6 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing() || (state & 6) != 6) {
                    // empty if block
                }
                if (frame.isResizable()) {
                    if ((state & 4) == 4 || (state & 2) == 2) {
                        this.updateToggleButton(this.restoreAction);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action) {
        this.toggleButton.setAction(action);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    public boolean isSelected() {
        Window window = this.getWindow();
        return window == null ? true : window.isActive();
    }

    public boolean isFrameMaximized() {
        Frame frame = this.getFrame();
        if (frame != null) {
            return (frame.getExtendedState() & 6) == 6;
        }
        return false;
    }

    public void paintComponent(Graphics g) {
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        Window frame = this.getWindow();
        boolean leftToRight = frame.getComponentOrientation().isLeftToRight();
        boolean isSelected = this.isSelected();
        if (isSelected) {
            this.prevState = true;
        }
        if (!this.prevState && !isSelected) {
            isSelected = true;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        Color foreground = LiquidLookAndFeel.getWindowTitleInactiveForeground();
        if (LiquidLookAndFeel.winDecoPanther) {
            this.drawPantherCaption(g, isSelected, width, height);
        } else {
            this.drawLiquidCaption(g, isSelected, width, height);
        }
        int titleLength = 0;
        int xOffset = leftToRight ? 2 : width - 2;
        String frameTitle = this.getTitle();
        if (frameTitle != null) {
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            titleLength = fm.stringWidth(frameTitle);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent() + 1;
            if (!leftToRight) {
                xOffset -= titleLength;
            }
            xOffset = width / 2 - titleLength / 2;
            if (isSelected) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (!LiquidLookAndFeel.winDecoPanther) {
                    GradientPaint grad = new GradientPaint(xOffset + titleLength / 2, yOffset - 15, new Color(60, 144, 233), xOffset + titleLength / 2, fm.getHeight() + 6, new Color(102, 186, 255));
                    g2.setPaint(grad);
                    g2.fillRoundRect(xOffset - 8, yOffset - 15, titleLength + 15, height - 6, 18, 18);
                    g.setColor(new Color(0, 78, 167));
                    g2.drawRoundRect(xOffset - 8, yOffset - 15, titleLength + 15, height - 6, 18, 18);
                }
                g.setColor(Color.black);
                if (!LiquidLookAndFeel.winDecoPanther) {
                    g.drawString(frameTitle, xOffset + 1, yOffset);
                    g.setColor(this.normalTitleColor);
                } else {
                    Frame _frame = null;
                    Dialog _dialog = null;
                    Image image = null;
                    Window w = this.getWindow();
                    if (w instanceof Frame) {
                        _frame = (Frame)w;
                        image = _frame.getIconImage();
                    } else {
                        _dialog = (Dialog)w;
                        if (_dialog.getParent() != null && _dialog.getParent() instanceof Frame) {
                            image = ((Frame)_dialog.getParent()).getIconImage();
                        }
                    }
                    if (image != null) {
                        g.drawImage(image, (xOffset += 10) - 20, 3, 16, 16, null);
                    } else {
                        Icon icon = UIManager.getIcon("InternalFrame.pantherIcon");
                        if (icon != null) {
                            icon.paintIcon(this, g, (xOffset += 10) - 20, 3);
                        }
                    }
                }
                g.drawString(frameTitle, xOffset, yOffset - 1);
                xOffset += leftToRight ? titleLength + 2 : -2;
            } else {
                Graphics2D g2 = (Graphics2D)g;
                if (!LiquidLookAndFeel.winDecoPanther) {
                    GradientPaint grad = new GradientPaint(xOffset + titleLength / 2, yOffset - 15, new Color(191, 211, 233), xOffset + titleLength / 2, fm.getHeight() + 6, new Color(233, 253, 255));
                    g2.setPaint(grad);
                    g2.fillRoundRect(xOffset - 8, yOffset - 15, titleLength + 15, height - 6, 18, 18);
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(new Color(125, 145, 167));
                    g2.drawRoundRect(xOffset - 8, yOffset - 15, titleLength + 15, height - 6, 18, 18);
                }
                if (LiquidLookAndFeel.winDecoPanther) {
                    Frame _frame = null;
                    Dialog _dialog = null;
                    Image image = null;
                    Window w = this.getWindow();
                    if (w instanceof Frame) {
                        _frame = (Frame)w;
                        image = _frame.getIconImage();
                    } else {
                        _dialog = (Dialog)w;
                        if (_dialog.getParent() != null && _dialog.getParent() instanceof Frame) {
                            image = ((Frame)_dialog.getParent()).getIconImage();
                        }
                    }
                    if (image != null) {
                        g.drawImage(image, (xOffset += 10) - 20, 3, 16, 16, null);
                    } else {
                        Icon icon = UIManager.getIcon("InternalFrame.pantherIconInactive");
                        if (icon != null) {
                            icon.paintIcon(this, g, (xOffset += 10) - 20, 3);
                        }
                    }
                }
                g.setColor(LiquidLookAndFeel.winDecoPanther ? new Color(115, 115, 115) : Color.black);
                g.drawString(frameTitle, xOffset, yOffset - 1);
                xOffset += leftToRight ? titleLength + 2 : -2;
            }
        }
    }

    private void drawLiquidCaption(Graphics g, boolean isSelected, int w, int h) {
        Color c = isSelected ? new Color(62, 145, 235) : new Color(175, 214, 255);
        g.setColor(c);
        g.fillRect(0, 0, w, h - 1);
        c = isSelected ? new Color(94, 172, 255) : new Color(226, 240, 255);
        g.setColor(c);
        g.drawLine(0, 0, w, 0);
        c = isSelected ? new Color(60, 141, 228) : new Color(170, 207, 247);
        g.setColor(c);
        g.drawLine(0, 1, w, 1);
        for (int i = 4; i < h - 1; i += 4) {
            c = isSelected ? new Color(59, 138, 223) : new Color(166, 203, 242);
            g.setColor(c);
            g.drawLine(0, i, w, i);
            c = isSelected ? new Color(60, 141, 228) : new Color(170, 207, 247);
            g.setColor(c);
            g.drawLine(0, i + 1, w, i + 1);
        }
        c = isSelected ? new Color(47, 111, 180) : new Color(135, 164, 196);
        g.setColor(c);
        g.drawLine(0, h - 1, w, h - 1);
    }

    private void drawPantherCaption(Graphics g, boolean isSelected, int w, int h) {
        Graphics2D g2 = (Graphics2D)g;
        GradientPaint grad = isSelected ? new GradientPaint(0.0f, 0.0f, new Color(238, 238, 238), 0.0f, h - 1, new Color(192, 192, 192)) : new GradientPaint(0.0f, 0.0f, new Color(230, 230, 230), 0.0f, h - 1, new Color(202, 202, 202));
        g2.setPaint(grad);
        g2.fillRect(0, 0, w, h - 1);
        g2.setColor(new Color(198, 198, 198));
        g2.drawLine(0, 0, w - 1, 0);
        g2.setColor(Color.WHITE);
        g2.drawLine(0, 1, w - 1, 1);
        g2.setColor(new Color(147, 147, 147));
        g2.drawLine(0, h - 1, w, h - 1);
    }

    private String clippedText(String text, FontMetrics fm, int availTextWidth) {
        if (text == null || text.equals("")) {
            return "";
        }
        int textWidth = SwingUtilities.computeStringWidth(fm, text);
        String clipString = "...";
        if (textWidth > availTextWidth) {
            int nChars;
            int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
            for (nChars = 0; nChars < text.length() && (totalWidth += fm.charWidth(text.charAt(nChars))) <= availTextWidth; ++nChars) {
            }
            text = text.substring(0, nChars) + clipString;
        }
        return text;
    }

    private int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    class WindowMoveListener
    extends ComponentAdapter {
        WindowMoveListener() {
        }

        public void componentMoved(ComponentEvent e) {
            if (LiquidTitlePane.this.getWindowDecorationStyle() == 0) {
                return;
            }
            Window w = LiquidTitlePane.this.getWindow();
            w.repaint(0, 0, w.getWidth(), 5);
        }

        public void componentResized(ComponentEvent e) {
            if (LiquidTitlePane.this.getWindowDecorationStyle() == 0) {
                return;
            }
            Window w = LiquidTitlePane.this.getWindow();
            w.repaint(0, 0, w.getWidth(), 5);
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowActivated(WindowEvent ev) {
            LiquidTitlePane.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent ev) {
            LiquidTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = LiquidTitlePane.this.getFrame();
                if (frame != null) {
                    LiquidTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    LiquidTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                LiquidTitlePane.this.repaint();
            } else if ("componentOrientation".equals(name)) {
                LiquidTitlePane.this.revalidate();
                LiquidTitlePane.this.repaint();
            }
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        private int computeHeight() {
            if (LiquidTitlePane.this.getFrame() instanceof JFrame) {
                LiquidTitlePane.this.setMaximizeBounds(LiquidTitlePane.this.getFrame());
                if (LiquidLookAndFeel.winDecoPanther) {
                    return 22;
                }
                return 25;
            }
            if (LiquidLookAndFeel.winDecoPanther) {
                return 22;
            }
            return 25;
        }

        public void layoutContainer(Container c) {
            int yOffset;
            int buttonWidth;
            int buttonHeight;
            if (LiquidTitlePane.this.getWindowDecorationStyle() == 0) {
                LiquidTitlePane.this.buttonsWidth = 0;
                return;
            }
            boolean leftToRight = LiquidTitlePane.this.window == null ? LiquidTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : LiquidTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int w = LiquidTitlePane.this.getWidth();
            if (LiquidTitlePane.this.closeButton != null) {
                buttonHeight = ((LiquidTitlePane)LiquidTitlePane.this).closeButton.getPreferredSize().height;
                buttonWidth = ((LiquidTitlePane)LiquidTitlePane.this).closeButton.getPreferredSize().width;
            } else {
                buttonHeight = 16;
                buttonWidth = 16;
            }
            int y = (LiquidTitlePane.this.getHeight() - buttonHeight) / 2 + 1;
            int x = leftToRight ? w : 0;
            int spacing = LiquidLookAndFeel.winDecoPanther ? 2 : 0;
            int n = x = leftToRight ? spacing : w - buttonWidth - spacing;
            if (LiquidTitlePane.this.menuBar != null) {
                LiquidTitlePane.this.menuBar.setBounds(x, y, buttonWidth, buttonHeight);
            }
            int n2 = x = leftToRight ? w : 0;
            x += LiquidLookAndFeel.winDecoPanther ? (leftToRight ? -spacing - 3 - buttonWidth : spacing) : (leftToRight ? -spacing - buttonWidth : spacing);
            int n3 = yOffset = LiquidLookAndFeel.winDecoPanther ? 1 : 0;
            if (LiquidTitlePane.this.closeButton != null) {
                LiquidTitlePane.this.closeButton.setBounds(x, y - yOffset, buttonWidth, buttonHeight);
            }
            if (LiquidTitlePane.this.menuButton != null) {
                LiquidTitlePane.this.menuButton.setBounds(3, y - yOffset + 1, 21, 12);
            }
            if (!leftToRight) {
                x += buttonWidth;
            }
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && LiquidTitlePane.this.toggleButton.getParent() != null) {
                LiquidTitlePane.this.toggleButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y - yOffset, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (LiquidTitlePane.this.iconifyButton != null && LiquidTitlePane.this.iconifyButton.getParent() != null) {
                LiquidTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y - yOffset, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            LiquidTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
        }
    }

    private class SystemMenuBar
    extends JMenuBar
    implements MouseListener {
        private JPopupMenu systemMenu;
        private boolean isShowed = false;

        public SystemMenuBar(JPopupMenu menu) {
            this.systemMenu = menu;
            this.addMouseListener(this);
        }

        protected void setSystemMenuVisible(boolean b) {
            this.isShowed = b;
        }

        public void paint(Graphics g) {
            Image image;
            if (LiquidLookAndFeel.winDecoPanther) {
                return;
            }
            Frame frame = LiquidTitlePane.this.getFrame();
            Image image2 = image = frame != null ? frame.getIconImage() : null;
            if (image != null) {
                g.drawImage(image, 0, 0, 16, 16, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g, 0, 0);
                }
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Icon icon = UIManager.getIcon("InternalFrame.icon");
            if (icon != null) {
                return new Dimension(icon.getIconWidth(), icon.getIconHeight());
            }
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(16, size.width), Math.max(size.height, 16));
        }

        public void mouseClicked(MouseEvent e) {
            if (!this.isShowed) {
                this.systemMenu.show(this, 0, 18);
                this.isShowed = true;
            } else {
                this.isShowed = false;
                this.systemMenu.setVisible(this.isShowed);
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (!this.systemMenu.isVisible()) {
                this.isShowed = false;
            }
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    private class MenuAction
    extends AbstractAction {
        public MenuAction() {
            super("Menu");
        }

        public void actionPerformed(ActionEvent e) {
            LiquidTitlePane.this.showMenu(LiquidTitlePane.this.createMenu());
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super("Maximize");
        }

        public void actionPerformed(ActionEvent e) {
            LiquidTitlePane.this.maximize();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super("Restore");
        }

        public void actionPerformed(ActionEvent e) {
            LiquidTitlePane.this.restore();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super("Minimize");
        }

        public void actionPerformed(ActionEvent e) {
            LiquidTitlePane.this.iconify();
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
        }

        public void actionPerformed(ActionEvent e) {
            LiquidTitlePane.this.close();
        }
    }
}

